# Description

This samples demonstrates how to integrate **Mobile Orchestration SDK** on an iOS device  
so as to interact with **OneSpan Adaptive Authentication Service**.  

The provided features are :  

1. Activation
2. Multi Users Management
3. Notification Registration
4. Local Authentication
5. Local Transaction
6. Remote Authentication (by notification)
7. Remote Transaction (by notification)
8. Change Password
9. Get Activation Information
10. Generate CDDC (not demonstrated in the sample)

User authentication methods available :
- No Protection  
- Password Protection (the sample show the external user password authentication)
- Biometric Protection

# Prerequisites

Before running the sample, you need to customize `ConfigurableConstants.swift`:    

1. Move to directory `OrchestrationSDKSample`   
 and open the `ConfigurableConstants.swift` file ;

2. Replace the values below :  

| Key                                  | Value 
|:------------------------------------ |:---------------:
| `ConfigurableConstants.accountIdentifier` | Identifier of your Onespan Developer Account as defined during your account creation on the [OneSpan Developer Portal](https://community.onespan.com/products/intelligent-adaptive-authentication/getting-started). Indicated as "Sandbox user"
| `ConfigurableConstants.Salt.storage` and `ConfigurableConstants.Salt.digipass` | Two different random strings of 64 hexadecimal characters
| `ConfigurableConstants.URLs.cloudServer` | String value representing the domain address starting with a dot for example: `.sdb.tid.onespan.cloud`
| `ConfigurableConstants.teamId` | String value representing your Apple Team ID
| `ConfigurableConstants.bundleId` | String value representing the bundle ID of the application

- The Minimum supported version is iOS 15

# Build and run  

## In Xcode  

It can be directly build and run with **Xcode**   

# How to use  
## Sample Configuration

1. Go to [OneSpan Developer Portal](https://community.onespan.com/products/intelligent-adaptive-authentication/getting-started)
2. "Login" or "register an account" using the "Sign Up"
3. Go to your sandbox page
4. Click on the "Update app" button to open the "Register My App" window
5. In this window you can:
    - Define your App Identifier: i.e. bundle identifier.
    - Upload your APNS certificate: PKCS#12 and PKCS#8 are supported.
    - Indicate the APNS password.
    - Indicate if this APNS is an Apple sandbox one.
6. Inside the sample, update the `Constants` file like indicated in the prerequisites section.
7. Build and run with **Xcode**

## Registration 
To activate an account you will need two things:
- User Identifier, choosed by the end user
- Activation Password, given by the server

1. Go to your sandbox page
2. Open the **Adaptive Authentication interactive API** link
3. Open `User>users/register` end point.
4. Click on `Try it out`
5. Inside the `Request body` change the `userID` by your own.
6. Click on `Execute`.
7. Retrive the `activationPassword` from the `Response body`
8. Open the mobile application.
9. Click on `Start Activation`.
10. Use the same `User ID` as before, and the `Activation Password` retrieved earlier
11. Click on `Register`
12. Choose a password

## Remote Authentication
**Prerequisite**:   
Device properly registered for push notifications.

**Process**:  

***Platform API***
1. Go back to the **Platform API Sandbox** (or Adaptive Authentication interactive API)
2. Open the `User>/users/{userID@domain}/login`
3. Click on `Try it out`
4. Enter your `userID` and your `domain` (Sandbox user) in the field `userID@domain`. Do not forget to insert a '@' between them
5. You need to change the Request body to the following:
```
{
    "objectType": "LoginInput",
    "credentials": { "passKey": "PIN"
    },
    "orchestrationDelivery": ["pushNotification"]
}
```

This will send a push notification to the mobile application.

***Mobile Application***

- A click on the notification will display the Login Activity
- The Login Controller is displayed with 2 buttons: accept / reject. 
- In both case : 
    1. The user authentication method pushed by **OneSpan Adaptive Authentication Service** is applied.
    2. Upon Success, a command is generated and sent to the server to inform of end user choice.
    3. A message is displayed on your device to inform you that the server correctly receive your message.  

